define([
    'backbone',
    'Layout',
    'modules/new-appointment-request/views/direct/preferred-date/month-collapsible',
    'modules/new-appointment-request/views/direct/preferred-date/date-collapsible',
], function(Backbone, Layout, MonthCollapsibleView, DateCollapsibleView) {
    'use strict';

    describe('Month Collapsible View', function() {
        var view;
        var $view;
        var firstDayOfMonth = new Date('06/01/2015');
        var model;
        var layout;

        firstDayOfMonth.setHours(0, 0, 0, 0);
        model = new Backbone.Model({
            date: firstDayOfMonth,
            id: 'june-2015',
            monthNameYear: 'June 2015',
            timeSlotsByDate: new Backbone.Collection(),
        });
        layout = new Layout();

        layout.render();

        beforeEach(function() {
            view = new MonthCollapsibleView({model: model});

            layout.showChildView('content', view);
            view.$el.trigger('create');
            $view = view.$el;
        });

        afterEach(function() {
            view.destroy();
        });

        describe('on show', function () {
            it('has DateCollapsibleView as its childView', function () {
                expect(view.childView).toBe(DateCollapsibleView);
            });

            it('is rendered as an expanded collapsible', function () {
                expect($view.hasClass('ui-collapsible-collapsed')).toBe(false);
            });

            it('has a month heading and pre-rendered jQuery Mobile 1.4.5 collapsible header', function () {
                expect($view.find('.ui-collapsible-heading span[aria-hidden="true"]').text()).toEqual('June 2015');
                expect($view.find('.ui-collapsible-heading').hasClass('ui-collapsible-heading-collapsed')).toBe(false);
                expect($view.find('.ui-collapsible-heading-status').text()).toEqual('June 2015 select to collapse content');
            });

            it('has pre-rendered, styled jQuery Mobile 1.4.5 collapsible content', function () {
                expect($view.find(view.childViewContainer).hasClass('available-dates')).toBe(true);
                expect($view.find(view.childViewContainer).attr('aria-hidden')).toEqual('false');
                expect($view.find(view.childViewContainer).hasClass('ui-collapsible-content-collapsed')).toBe(false);
            });
        });
    });
}
);
